<?php

/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2015 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class imaxuncheckonsale extends Module {

    const PREFIJO = 'IMAX_UNCKE_';

    public function __construct() {
        $this->name = 'imaxuncheckonsale';
        $this->tab = 'content_management';
        $this->version = '1.1';
        $this->author = 'Informax';
        $this->need_instance = 0;
        $this->idManual = 364;
        $this->sufijo = self::PREFIJO;



        parent::__construct();

        $this->displayName = $this->l('Uncheck On sale');
        $this->description = $this->l('Uncheck On sale');

        $this->confirmUninstall = $this->l('Estas seguro de desinstalar??');

        if (version_compare(_PS_VERSION_, '1.7.0.0 ', '>=')) {
            $this->versionPS = 17;
            $context = Context::getContext();
            $this->idShop = $context->shop->id;
            $this->idLang = $context->language->id;
        } else if (version_compare(_PS_VERSION_, '1.6.0.0 ', '>=')) {
            $this->versionPS = 16;
            $context = Context::getContext();
            $this->idShop = $context->shop->id;
            $this->idLang = $context->language->id;
        } else if (version_compare(_PS_VERSION_, '1.5.0.0 ', '>=')) {
            $this->versionPS = 15;
            $context = Context::getContext();
            $this->idShop = $context->shop->id;
            $this->idLang = $context->language->id;
        } else if (version_compare(_PS_VERSION_, '1.4.0.0 ', '>=')) {
            $this->versionPS = 14;
            $this->idLang = $cookie->id_lang;
            $this->idShop = 1;
        } else {
            $this->l("La version minima de funcionamiento para nuestros modulos es la 1.4");
            die();
        }
        $this->getTxtFiles();
    }

    public function install() {
        $sql = array();
        if (!parent::install())
            return false;

        $configuracion = array();
        include(dirname(__FILE__) . '/configuration.php');
        foreach ($configuracion as $indice => $valor)
            if (!Configuration::updateGlobalValue($indice, $valor))
                return false;

        if (!$this->installTab()) {
            $this->_errors[] = $this->l('Tab instalation failed');
            return false;
        }

        include(dirname(__FILE__) . '/sql/install.php');
        foreach ($sql as $s)
            if (!Db::getInstance()->execute($s))
                return false;


        $directorioAdmin = getcwd();
        if (!copy(dirname(__FILE__) . '/' . $this->name . '_cron.php', $directorioAdmin . '/' . $this->name . '_cron.php')) {
            return false;
        }

        return true;
    }

    public function uninstall() {
        $sql = array();
        if (!parent::uninstall())
            return false;

        include(dirname(__FILE__) . '/sql/uninstall.php');
        foreach ($sql as $s)
            if (!Db::getInstance()->execute($s))
                return false;

        $configuracion = array();
        include(dirname(__FILE__) . '/configuration.php');
        foreach ($configuracion as $indice => $valor) {
            if (Configuration::getGlobalValue($indice) !== false) {
                if (!Configuration::deleteByName($indice)) {
                    $this->_errors[] = $this->l('A configuration key cannot be deleted: ') . $indice .
                            $this->l(' with value: ') . $valor;
                    return false;
                }
            }
        }

        if (!$this->uninstallTab())
            $this->_errors[] = $this->l('Tab uninstalation failed');

        return true;
    }

    /**
     * Load the configuration form
     */
    public function getContent() {
        $this->addCSS('publi.css');

        $html = $this->createHelpHeader();
        if (!empty($_POST))
            $html .= $this->postProcess();
        $html .= $this->displayForm();
        $html .= $this->getModuleFooter();

        return $html;
    }

    private function displayForm() {
        if ($this->id_tab == '' || empty($this->id_tab))
            $this->id_tab = 1;

        $html = '	   
			<ul id="menuTab">
			<li id="menuTab1" class="menuTabButton' . (($this->id_tab == 1) ? ' selected' : '') . '">1. ' .
                $this->l('Configuracion') . '</li>			
			</ul>
			<div id="tabList">
			<div id="menuTab1Sheet" class="tabItem' . (($this->id_tab == 1) ? ' selected' : '' ) . '">' .
                $this->configuracion() . '</div>			
			</div>
			<br clear="left" />
			<style>
			#menuTab { float: left; padding: 0; margin: 0; text-align: left; }
			#menuTab li { text-align: left; float: left; display: inline; padding: 5px; padding-right: 10px; 
				background: #EFEFEF; font-weight: bold; 
			cursor: pointer; border-left: 1px solid #EFEFEF; border-right: 1px solid #EFEFEF; 
				border-top: 1px solid #EFEFEF; }
			#menuTab li.menuTabButton.selected { background: #FFF6D3; border-left: 1px solid #CCCCCC; 
				border-right: 1px solid #CCCCCC; 
			border-top: 1px solid #CCCCCC; }
			#tabList { clear: left; }
			.tabItem { display: none; }
			.tabItem.selected { display: block; background: #FFFFF0; border: 1px solid #CCCCCC; padding: 10px; 
				padding-top: 20px; }
			</style>

			<script>
                $(".menuTabButton").click(function () {
                $(".menuTabButton.selected").removeClass("selected");
                $(this).addClass("selected");
                $(".tabItem.selected").removeClass("selected");
                $("#" + this.id + "Sheet").addClass("selected");								 
			});

			var rutaImagenes = "' . _THEME_LANG_DIR_ . '";
			</script>';

        return $html;
    }

    private function configuracion() {
        $directorioAdmin = getcwd();
        $html = '
			<fieldset><legend>' . $this->l('Cree una tarea cron una vez al dia') . '</legend>
				<p><a href="' . $this->getUrlAdmin() . $this->name . '_cron.php" target="_blank">
                                ' . $this->getUrlAdmin() . $this->name . '_cron.php</a></p></p>
			</fieldset><br/>';


        $html .= $this->displayWarning('Este modulo elimina la etiqueta en oferta cuando los productos ya no estan en oferta');
        return $html;
    }

    static function getUrlAdmin() {
        $temp = explode('/', $_SERVER['PHP_SELF']);
        $dummy = array_pop(($temp));
        $urlAdmin = implode('/', $temp);
        if (ConfigurationCore::get('PS_SSL_ENABLED') == 1) {
            $url = 'https://';
        } else {
            $url = 'http://';
        }
        $url .= $_SERVER['SERVER_NAME'] . $urlAdmin . '/';
        return $url;
    }

    public function displayWarning($error) {
        if ($this->versionPS == 15) {
            $output = '
			<div class="module_error alert warn">
				' . $error . '
			</div>';
        } else {
            $output = '<div class="bootstrap">'
                    . '<p class="warning warn alert alert-warning">'
                    . $error .
                    '</p></div>';
        }
        return $output;
    }

    /**
     * Add the CSS & JavaScript files you want to be added on the FO.
     */
    public function procesar() {
        $resultadoTexto = '';
        $sql = 'SELECT 
                      *
              FROM
                      ' . _DB_PREFIX_ . 'product AS p
              WHERE
                      p.on_sale = 1 
              AND p.id_product NOT IN
              (SELECT id_product FROM ' . _DB_PREFIX_ . 'specific_price)';
        $resultado = Db::getInstance()->executeS($sql);
        if ($resultado) {
            foreach ($resultado as $p) {
                $producto = new Product($p['id_product']);
                $producto->on_sale = 0;
                $producto->update();
                $resultadoTexto .= $this->l('Producto desmarcado') . $p['id_product'];
            }
        } else {
            $resultadoTexto .= $this->l('No hay productos que desmarcar');
        }
        return $resultadoTexto;
    }

    /**
     * Save form data.
     */
    private function postProcess() {
        $this->id_tab = Tools::getValue('id_tab');
        $accion = Tools::getValue('accion');
        $html = '';
        return $html;
    }

    private function addCSS($css) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            if ($this->context->controller instanceof stdClass)
                $this->context->controller = new AdminModulesController();
            $this->context->controller->addCss($this->_path . 'views/css/' . $css, 'all');
        }
    }

    private function addJS($js) {
        $tab = Tools::getValue('tab', 0);
        if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
            if ($this->context->controller instanceof stdClass)
                $this->context->controller = new AdminModulesController();
            $this->context->controller->addJs($this->_path . 'js/' . $js);
        }
    }

    public function createHelpHeader() {
        $html = '<div class="module-preheader">';
        $html .= $this->getDatosPubli('header');
        $html .= '</div>';

        $html .= '<div class="module-header">';
        $html .= '<div class="module-title-container">';
        $html .= '<h2 class="module-title">' . $this->displayName . '<small> by Informax</small></h2>';
        $html .= '<h3 class="module-version">' . $this->l('Version: ') . $this->version . '</h3>';
        $html .= '</div>';

        $html .= '<div class="module-toolbar">';
        $html .= '<ul class="module-nav" >';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://www.informax.es">';
        $html .= '<img src="../modules/' . $this->name . '/img/informax.png">';
        $html .= '<div>' . $this->l('Informax') . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://tickets.informax.es/open.php?topicId=10">';
        $html .= '<img src="../modules/' . $this->name . '/img/abrir-ticket.png">';
        $html .= '<div>' . $this->l('Asistencia') . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '<li>';
        $html .= '<a target="_blank" href="http://docs.informax.es/?p=' . $this->idManual . '">';
        $html .= '<img src="../modules/' . $this->name . '/img/ir-a-manuales.png">';
        $html .= '<div>' . $this->l('Manuales') . '</div>';
        $html .= '</a>';
        $html .= '</li>';

        $html .= '</ul>';
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }

    public function getModuleFooter() {
        $url = Configuration::getGlobalValue($this->sufijo . 'URL_FALDON');
        $html = '<div class="module-newsletter">';
        $html .='<form action="http://www.informax.es/subscribe/" method="post" target="_blank">
                    <input type="hidden" name="accion" value="newsletter">
                    <input type="hidden" name="idTab" value="1" />';
        $html .= '<p>' . $this->l('Si deseas enterarte de todos los cambios en nuestros modulos, nuevos Modulos, como funciona Prestashop, apuntate a nuestras news') . '</p>';
        $html .= ' <p>';
        $html .= ' <label>' . $this->l('email') . '</label>';
        $html .= '<input type="text" name="email" value="" />';
        $html .= '<input type="submit" name="subscribe" value="' . $this->l('Guardar') . '" />';
        $html .= '</p>';
        $html .= '</form><br />';
        $html .= '</div>';
        $html .= '<div class="module-footer">';
        $html .= '<div class="module-footer-left">';
        $html .= $this->getDatosPubli('footera');
        $html .= '</div>';
        $html .= '<div class="module-footer-right">';
        $html .= $this->getDatosPubli('footerb');
        $html .= '</div>';
        $html .= '</div>';
        return $html;
    }

    public function getDatosPubli($tipo) {
        $datosCompletos = Configuration::getGlobalValue($this->sufijo . 'TXT_FILE');
        $html = '';
        if ($datosCompletos) {
            $aperturaA = '';
            $cierreA = '';
            $datosCompletos = @unserialize($datosCompletos);
            if (!is_array($datosCompletos)) {
                return '';
            }
            shuffle($datosCompletos);
            foreach ($datosCompletos AS $datoElemento) {
                if ($datoElemento[1] == $tipo) {
                    if (trim($datoElemento[2]) != '') {
                        $aperturaA .= '<a href="' . $datoElemento[2] . '" target="_blank">';
                        $cierreA = '</a>';
                    }
                    if (trim($datoElemento[0]) != '') {
                        $html = $aperturaA . '<img src="' . Configuration::getGlobalValue($this->sufijo . 'URL_TXT') . '/img/' . $datoElemento[0] . '" />' . $cierreA;
                    }
                    return $html;
                }
            }
        }
        return $html;
    }

    public function getTxtFiles() {
        if (Configuration::getGlobalValue($this->sufijo . 'DESCARGA_ARCHIVO') < 1000) {
            Configuration::updateGlobalValue($this->sufijo . 'DESCARGA_ARCHIVO', Configuration::getGlobalValue($this->sufijo . 'DESCARGA_ARCHIVO') + 1);
            return false;
        }
        $url = Configuration::getGlobalValue($this->sufijo . 'URL_TXT') . '/' . Configuration::getGlobalValue($this->sufijo . 'TIPO') . '.txt';
        $basedir_active = ini_get('open_basedir');
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_BINARYTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        if (!$basedir_active) {
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
        }
        $datos = curl_exec($ch);
        $infoCurl = curl_getinfo($ch);

        if (!isset($infoCurl['http_code']) || $infoCurl['http_code'] != 200) {
            return false;
        }
        Configuration::updateGlobalValue($this->sufijo . 'DESCARGA_ARCHIVO', 0);
        return Configuration::updateGlobalValue($this->sufijo . 'TXT_FILE', $this->readCsv($datos));
    }

    private function readCsv($string) {
        $string = trim($string);
        $temp = explode("\n", $string);
        $respuesta = array();
        foreach ($temp AS $elemento) {
            $elementoInterno = array();
            $elementoInterno = explode(";", $elemento);
            $respuesta[] = $elementoInterno;
        }
        return serialize($respuesta);
    }

    /**
     * Crea un nuevo tab.
     * @param string $clase
     * @param string $nombre
     * @param string $padre
     * @return boolean
     */
    private function crearTab($clase, $nombre, $padre = '') {
        if (!Tab::getIdFromClassName($clase)) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = $clase;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = $nombre;
            }
            if ($padre == '') {
                $posicion = 0;
            } else {
                $posicion = Tab::getIdFromClassName($padre);
            }
            $tab->id_parent = intval($posicion);
            $tab->module = $this->name;
            try {
                if (!$tab->add()) {
                    return false;
                }
            } catch (Exception $exc) {
                return false;
            }
        }

        return true;
    }

    /**
     * Borra un tab.
     * @param string $clase
     * @return boolean
     */
    private function borrarTab($clase) {
        $id_tab = (int) Tab::getIdFromClassName($clase);
        if ($id_tab) {
            $tab = new Tab($id_tab);
            try {
                if (!$tab->delete()) {
                    return false;
                }
            } catch (Exception $exc) {
                return false;
            }
        }

        return true;
    }

    /**
     * Instala los tabs del módulo.
     * @return boolean
     */
    private function installTab() {
        include(dirname(__FILE__) . '/configuration.php');

        //Instalamos el root
        if (isset($moduleTabRoot) && $moduleTabRoot) {
            $this->crearTab($moduleTabRoot['clase'], $moduleTabRoot['name']);
        }

        //Instalamos el resto de tabs
        if (isset($moduleTabs) && $moduleTabs) {
            foreach ($moduleTabs AS $moduleTab) {
                $this->borrarTab($moduleTab['clase']);
                if (!$this->crearTab($moduleTab['clase'], $moduleTab['name'], $moduleTab['padre'])) {
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * Desinstala los tabs del módulo.
     * @return boolean
     */
    private function uninstallTab() {
        include(dirname(__FILE__) . '/configuration.php');

        //Desinstalamos las tabs de este módulo
        if (isset($moduleTabs) && $moduleTabs) {
            foreach ($moduleTabs AS $moduleTab) {
                if (!$this->borrarTab($moduleTab['clase'])) {
                    return false;
                }
            }
        }

        //Desinstalamos el root si está vacío
        if (isset($moduleTabRoot) && $moduleTabRoot) {
            $id_tab = (int) Tab::getIdFromClassName($moduleTabRoot['clase']);
            if ($id_tab && Tab::getNbTabs($id_tab) == 0) {
                if (!$this->borrarTab($moduleTabRoot['clase'])) {
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * Add the CSS & JavaScript files you want to be loaded in the BO.
     */
    public function hookBackOfficeHeader() {
        if (Tools::getValue('module_name') == $this->name) {
            $this->context->controller->addJS($this->_path . 'views/js/back.js');
            $this->context->controller->addCSS($this->_path . 'views/css/back.css');
        }
    }

    /**
     * Add the CSS & JavaScript files you want to be added on the FO.
     */
    public function hookHeader() {
        $this->context->controller->addJS($this->_path . '/views/js/front.js');
        $this->context->controller->addCSS($this->_path . '/views/css/front.css');
    }

}
