<?php

class imaxForm extends Module {

	function __construct($modulePath = '', $action = '', $method = 'post', $name = '', $enctype = '') {
		if ($action == '') {
			$action = Tools::safeOutput($_SERVER['REQUEST_URI']);
		}
		if ($enctype != '') {
			$enctype = 'enctype="' . $enctype . '"';
		}
		$this->formulario = '<form name="' . $name . '" action="' . $action . '" method="' . $method . '" ' . $enctype . '>';
		$this->context = Context::getContext();
		$this->_path = $modulePath;
		$this->addCSS('forms.css');
		$this->addJS('forms.js');
		parent::__construct();
	}

	function addToForm($html) {
		$this->formulario .= $html;
	}

	function renderForm() {
		$this->formulario .= '</form>';
		$formulario = $this->formulario;
		return $formulario;
	}

	/**
	 * Crea un elemento informativo
	 * @param string $text Texto a mostrar
	 * @param string $class Clase del elemento (warning (defecto), confirm)
	 * @param bool $html El texto contiene html  (No se traduce)
	 */
	function createFormInfomationText($text, $class = 'warning', $html = false) {
		switch ($class) {
			case 'warning':
				$class = ' warning warn alert  alert-warning ';
				break;
			case 'confirm':
				$class = ' module_confirmation conf confirm alert alert-success ';
				break;
			default:
				break;
		}
		$html = '';
		$html .= '<div class="form-group">';
		$html .= '<div class="bootstrap imaxBootstrap">';
		$html .= '<p class="' . $class . '">';
		if ($html == true) {
			$html .= $text;
		} else {
			$html .= $this->l($text);
		}
                $html .= '</p>';
		$html .= '</div>';
		$html .= '</div>';
		$html .= '<br class="clear"/>';
		$this->formulario .= $html;
	}

	/**
	 * Crea un checkbox
	 * @param string $name Nombre del checkbox
	 * @param string $text Texto informativo
	 * @param boolean $checked Marcado(true) o no(false), por defecto false
	 * @param string $title Titulo
	 */
	function createFormCheckboxGroup($name, $text, $checked = false, $title = '') {
		$marcado = '';
		if ($checked == true) {
			$marcado = ' checked="checked"';
		}
		$html = '';
		$html .= '<div class="form-group">';
		$html .= '<label for="' . $name . '" class="control-label col-lg-3">';
		$html .= '<span title="' . $title . '">';
		$html .= $this->l($text);
		$html .= '</span>';
		$html .= '</label>';
		$html .= '<div class="col-lg-3">';
		$html .= '<input type="checkbox" ' . $marcado . ' value="1" name="' . $name . '" id="' . $name . '">';
		$html .= '</div>';
		$html .= '</div>';
		$this->formulario .= $html;
	}

	function createFormRadioButtonGroup($datos, $name, $extras = false) {
		$html = '';
		$html .= '<div class="form-group">';
		$html .= '<label class="control-label col-lg-3">' . $name . '</label>';
		$html .= '<div class="col-lg-9">';
		foreach ($datos AS $indice => $dato) {
			$checked = '';
			if (isset($dato['checked']) && $dato['checked'] == 1) {
				$checked = ' checked="checked"';
			}
			$html .= '<div class="radio">';
			$html .= '<label>';
			$html .= '<input ' . $checked . ' type="radio" value="' . $dato['value'] . '" name="' . $dato['name'] . '"';

			if ($extras && $extras[$indice]) {
				foreach ($extras[$indice] AS $indiceExtras => $extra) {
					$html .= $indiceExtras . '="' . $extra . '"';
				}
			}
			$html .= ' />';

			$html .= $dato['text'];
			$html .= '</label>';
			$html .= '</div>';
		}
		$html .= '</div>';
		$html .= '</div>';
		$this->formulario .= $html;
	}

	public function generarTextArea($name, $contenido, $text, $title = '', $multiLang = 0) {
		$html = '';
		$html .= '<label class="control-label col-lg-3">';
		$html .= '<span class="label-tooltip" data-toggle="tooltip" title="" data-original-title="'.$title.'">';
		$html .= $text;
		$html .= '</span>';
		$html .= '</label>';
		if ($multiLang) {
			$idiomas = $this->getLanguages();
			$idiomasSelect = $idiomas;
			foreach ($idiomas AS $language) {
				$html .= '<div class="translatable-field row lang-' . $language['id_lang'] . '">';
				$html .= '<div class="col-lg-9">';
				$html .= '<textarea ';
				$html .= ' id="' . $name . '_' . $language['id_lang'] . '"';
				$html .= ' name="' . $name . '_' . $language['id_lang'] . '"';
				$html .= ' class="autoload_rte">';
				$html .= $contenido;
				$html .= ' </textarea>';
				$html .= ' </div>';
				$html .= ' <div class="col-lg-2">';
				$html .= ' <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">';
				$html .= $language['iso_code'];
				$html .= ' <span class="caret"></span>';
				$html .= ' </button> ';
				$html .= ' <ul class="dropdown-menu"> ';
				foreach ($idiomasSelect AS $idiomaSelect) {
					$html .= ' <li><a href="javascript:hideOtherLanguage(' . $idiomaSelect['id_lang'] . ');">' . $language['name'] . '</a></li>';
				}
				$html .= ' </ul> ';
				$html .= ' </div> ';
				$html .= ' </div> ';
			}
		}else {
			$html .= '<div class="col-lg-9">';
				$html .= '<textarea ';
				$html .= ' id="' . $name .'"';
				$html .= ' name="' . $name . '"';
				$html .= ' class="autoload_rte">';
				$html .= $contenido;
				$html .= ' </textarea>';
				$html .= ' </div>';
		}
		$html .= '<script>';
		$html .= 'tinySetup({ ';
		$html .= 'editor_selector: "autoload_rte"';
		$html .= '}); ';
		$html .= '</script>';
		$this->formulario .= $html;
	}

	function createFormTextGroup($name, $value, $text, $title = '', $password = 0) {
		$tipo = 'text';
		if ($password == 1) {
			$tipo = 'password';
		}
		$html = '';
		$html .= '<div class="form-group">';
		$html .= '<label for="' . $name . '" class="control-label col-lg-3">';
		$html .= '<span title="' . $title . '">';
		$html .= $this->l($text);
		$html .= '</span>';
		$html .= '</label>';
		$html .= '<div class="col-lg-3">';
		$html .= '<input type="' . $tipo . '" value="' . $value . '" name="' . $name . '" id="' . $name . '">';
		$html .= '</div>';
		$html .= '</div>';
		$this->formulario .= $html;
	}

	function createFormSelectNumerico($name, $text, $defaultValue, $min, $max, $step = 1, $title = '') {
		$html = '';
		$html .= '<div class="form-group">';
		$html .= '<label for="' . $name . '" class="control-label col-lg-3">';
		$html .= '<span title="' . $title . '">';
		$html .= $this->l($text);
		$html .= '</span>';
		$html .= '</label>';
		$html .= '<div class="col-lg-3">';
		$html .= '<select name="' . $name . '" id="' . $name . '">';
		for ($i = $min; $i < $max; $i = $i + $step) {
			$selected = '';
			if ($i == $defaultValue) {
				$selected = ' selected="selected" ';
			}
			$html .= '<option value="' . $i . '" ' . $selected . '>' . $i . '</option>';
		}
		$html .= '</select>';
		$html .= '</div>';
		$html .= '</div>';
		$this->formulario .= $html;
	}

	function createHidden($name, $value) {
		$html = '<input type="hidden" name="' . $name . '" value="' . $value . '" />';
		$this->formulario .= $html;
	}

	function createSubmitButton($name, $text) {
		$html = '<button class="btn btn-default pull-right" name="' . $name . '" type="submit">';
		$html .= '<i class="process-icon-save"></i>' . $text . '</button>';
		$this->formulario .= $html;
	}

	function createButton($name, $text, $extras = false, $type = 'button', $icon = 'plus') {
		$html = '<button class="btn btn-default pull-right" name="' . $name . '" type="' . $type . '"';
		if ($extras && is_array($extras)) {
			foreach ($extras AS $indice => $extra) {
				$html.= ' ' . $indice . '="' . $extra . '"';
			}
		}

		$html .= '>';
		$html .= '<i class="process-icon-' . $icon . '"></i>' . $text . '</button>';
		$this->formulario .= $html;
	}

	/**
	 * Crea un select.
	 * @param string $nombre
	 * @param array $valores valor => visible
	 * @param string $claveValor La clave en el array para los valores. Si el array es de una dimension se ignora.
	 * @param string $claveVisible La clave en el array para el texto visible. Si el array es de una dimension se ignora.
	 * @param string $valorSeleccionado
	 * @return string
	 */
	function createFormSelect($name, $text, $datos, $defaultValue, $title) {
		$html = '';
		$html .= '<div class="form-group">';
		$html .= '<label for="' . $name . '" class="control-label col-lg-3">';
		$html .= '<span title="' . $title . '">';
		$html .= $this->l($text);
		$html .= '</span>';
		$html .= '</label>';
		$html .= '<div class="col-lg-3">';
		$html .= '<select name="' . $name . '" id="' . $name . '">';
		foreach ($datos AS $valor => $texto) {
			$selected = '';
			if ($valor == $defaultValue) {
				$selected = ' selected="selected" ';
			}
			$html .= '<option value="' . $valor . '" ' . $selected . '>' . $texto . '</option>';
		}
		$html .= '</select>';
		$html .= '</div>';
		$html .= '</div>';
		$this->formulario .= $html;
	}

	
	
	public function createFormFileButton($name, $label, $title, $url, $extras = null) {
		$this->addJS('spin.js');
		$this->addJS('ladda.js');
		
		$this->addJS('jquery.iframe-transport.js');
		$this->addJS('jquery.fileupload.js');		
		$this->addJS('jquery.fileupload-process.js');
		$this->addJS('jquery.fileupload-validate.js');
		//$this->addJS('jquery.fileupload-image.js');
		
		$html = '';
		$html .= '<div class="form-group">';
		$html .= '<label for="'.$name.'" class="control-label col-lg-3">';
		$html .= '<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="'.$title.'">'.$label.'</span>';
		$html .= '</label>';
		$html .= '<div class="col-lg-8 bootstrap">';
		$html .= '<input type="file" class="hide" data-url="'.$url.'" name="'.$name.'" id="'.$name.'">';
		$html .= '<button id="'.$name.'-add-button" type="button" data-size="s" data-style="expand-right" class="btn btn-default"><span class="ladda-label">';
		$html .= '<i class="icon-plus-sign"></i> '.$label.'';
		$html .= '</span><span class="ladda-spinner"></span></button>';
		$html .= '<!--';
		$html .= '<div class="alert alert-success" id="'.$name.'-success" style="display:none">'.$this->l('Carga exitosa').'</div>';
		$html .= '<div class="alert alert-danger" id="'.$name.'-errors" style="display:none"></div>';
		$html .= '-->';
		$html .= '</div>';
		/*
		$html .= '<script type="text/javascript">';
		$html .= 'function humanizeSize(bytes)';
		$html .= '{';
		$html .= 'if (typeof bytes !== "number") {';
		$html .= 'return ""';
		$html .= '}';
		$html .= 'if (bytes <= 1000000000) {';
		$html .= 'return (bytes / 1000000000).toFixed(2) + " GB";';
		$html .= '}';
		$html .= 'if (bytes <= 1000000) {';
		$html .= 'return (bytes / 1000000).toFixed(2) + " MB";';
		$html .= '}';
		$html .= 'return (bytes / 1000).toFixed(2) + " KB";';
		$html .= '}';
		$html .= '$(document ).ready(function() {';
		$html .= 'var '.$name.'_add_button = Ladda.create(document.querySelector("#'.$name.'-add-button"));';
		$html .= 'var '.$name.'total_files=0;';
		$html .= 'var success_message = "'.$this->l("Carga exitosa").'";';
		$html .= '$("#'.$name.'").fileupload({';
		$html .= 'dataType: "json",';
		$html .= 'autoUpload: true,';
		$html .= 'singleFileUploads: true,';
		$html .= 'maxFileSize: 838860800,';
		$html .= 'success: function (e) {';
		//$html .= '//showSuccessMessage(success_message);';
		$html .= '},';
		$html .= 'start: function (e) {';
		$html .= ''.$name.'_add_button.start();';
		$html .= '},';
		$html .= 'fail: function (e, data) {';
		$html .= 'showErrorMessage(data.errorThrown.message);';
		$html .= '},';
		$html .= 'done: function (e, data) {';
		$html .= 'console.log(data);';
		$html .= 'if (data.result) {';
		$html .= '	if (typeof data.codError !== "undefined") {';
		$html .= '		if (data.result.codError > 0) {';
		$html .= '			showErrorMessage(data.result.msgError + " : " + error);';
		$html .= '		}else { ';
		$html .= '			showSuccessMessage(success_message);';
		$html .= '		}';
		$html .= '	}';
		$html .= '}';		
		$html .= '}';
		$html .= '}).on("fileuploadalways", function (e, data) {';
		$html .= 'attachment_file_add_button.stop();';
		$html .= '}).on("fileuploadprocessalways", function (e, data) {';
		$html .= 'var index = data.index,	file = data.files[index];';
			//if (file.error)
				//$('#attachment_file-errors').append('&lt;div class="row"&gt;&lt;strong&gt;'+file.name+'&lt;/strong&gt; ('+humanizeSize(file.size)+') : '+file.error+'&lt;/div&gt;').show();
		$html .= '}).on("fileuploadsubmit", function (e, data) {';
		$html .= 'var params = new Object();';
		$html .= '$(\'input[id^="attachment_name_"]\').each(function()';
		$html .= '{';
		$html .= 'id = $(this).prop("id").replace("attachment_name_", "attachment_name[") + "]";';
		$html .= 'params[id] = $(this).val();';
		$html .= '});';
		/*
		$html .= '$(\'textarea[id^="attachment_description_"]\').each(function()';
		$html .= '{';
		$html .= 'id = $(this).prop("id").replace("attachment_description_", "attachment_description[") + "]";';
		$html .= 'params[id] = $(this).val();';
		$html .= '});';
		


		$html .= 'data.formData = params;';
		$html .= '});';
		$html .= '$("#'.$name.'-add-button").on("click", function() {';
			//$('#attachment_file-success').hide();
			//$('#attachment_file-errors').html('').hide();
		$html .= 'attachment_file_total_files = 0;';
		$html .= '$("#'.$name.'").trigger("click");';
		$html .= '});';
		$html .= '});';
		$html .= '</script>';
		 */
		$html .= "<script type='text/javascript'>
			function humanizeSize(bytes) {
				if (typeof bytes !== 'number') {
					return '';
				}
				if (bytes <= 1000000000) {
					return (bytes / 1000000000).toFixed(2) + ' GB';
				}
				if (bytes <= 1000000) {
					return (bytes / 1000000).toFixed(2) + ' MB';
				}
				return (bytes / 1000).toFixed(2) + ' KB';
				}
			$(document ).ready(function() {				
				var ".$name."_add_button = Ladda.create(document.querySelector('#".$name."-add-button'));
				var ".$name."total_files=0;
				var success_message = '".$this->l("Carga exitosa")."'
				$('#".$name."-add-button').removeAttr('disabled');
				$('#".$name."').fileupload({
					dataType: 'json',
					autoUpload: true,
					singleFileUploads: true,
					maxFileSize: 838860800,
					success: function (e) {
						//showSuccessMessage(success_message);
					},
					start: function (e) {
						".$name."_add_button.start();
					},
					fail: function (e, data) {
						showErrorMessage(data.errorThrown.message);
					},
					done: function (e, data) {
						if (data.result) {							
							if (data.result.codError != 0) {
								showErrorMessage(data.result.msgError);
							}else { 
								showSuccessMessage(data.result.msgError);
							}
						}
						console.log('#".$name."-add-button', 'por aqui SIIIIII PASAAAAAAA');
						$('#".$name."-add-button').removeProp('disabled');
					}
				}).on('fileuploadalways', function (e, data) {				
					$('#".$name."-add-button').removeProp('disabled');
				}).on('fileuploadprocessalways', function (e, data) {
					var index = data.index,	file = data.files[index];
				}).on('fileuploadsubmit', function (e, data) {
					var params = new Object();
					$('input[id^=\"".$name."_name_\"]').each(function() {
						id = $(this).prop('id').replace('".$name."_name_', '".$name."_name[') + ']';
						params[id] = $(this).val();
				});
				$('textarea[id^=\"".$name."_description_\"]').each(function() {
					id = $(this).prop('id').replace('".$name."_description_', '".$name."_description[') + ']';
					params[id] = $(this).val();
				});
				data.formData = params;
				});
			$('#".$name."-add-button').on('click', function() {
				//$('#attachment_file-success').hide();
				//$('#attachment_file-errors').html('').hide();
				".$name."_file_total_files = 0;
				$('#".$name."').trigger('click');
			});
		});";
		$html .= '</script>';
		$html .= '</div>';
		$this->formulario .= $html;
	}
	
	public function createFormFile($name, $text, $title = '') {
		$html = '';
		$html .= '<div class="form-group">';
		$html .= '<label for="' . $name . '" class="control-label col-lg-3">';
		$html .= '<span title="' . $title . '">';
		$html .= $this->l($text);
		$html .= '</span>';
		$html .= '</label>';
		$html .= '<div class="col-lg-3">';
		$html .= '<input type="file" name="' . $name . '" id="' . $name . '">';
		$html .= '</div>';
		$html .= '</div>';
		$this->formulario .= $html;
	}
	
	
	public function generarSelectIdioma($name, $text, $defaultValue, $title) {
		$html = '';
		$html .= '<div class="form-group">';
		$html .= '<label for="' . $name . '" class="control-label col-lg-3">';
		$html .= '<span title="' . $title . '">';
		$html .= $this->l($text);
		$html .= '</span>';
		$html .= '</label>';
		$html .= '<div class="col-lg-3">';
		$html .= '<select name="' . $name . '" id="' . $name . '" class="selectIdioma">';
		$idiomas = Language::getLanguages();
		foreach ($idiomas AS $idioma) {
			$selected = '';
			if ($defaultValue == $idioma['id_lang']) {
				$selected = ' selected="selected" ';
			}
			$html .= '<option value="' . $idioma['id_lang'] . '" ' . $selected . '>' . $idioma['name'] . '</option>';
		}
		$html .= '</select>';
		$html .= '</div>';
		$html .= '</div>';
		reset($idiomas);
		$html .= '<style>';
		foreach ($idiomas AS $idioma) {
			$html .= " .selectIdioma option[value='{$idioma['id_lang']}'] { background-image: url('.." . _THEME_LANG_DIR_ . "{$idioma['id_lang']}.jpg'); }";
		}
		$html .= '</style>';
		$html .= '<script>';
		$html .= ' var rutaImagenes="..' . _THEME_LANG_DIR_ . '"';
		$html .= '</script>';
		$this->formulario .= $html;
	}

	/*
	  function crearSelect($nombre, $valores, $claveValor = '', $claveVisible = '', $valorSeleccionado = FALSE) {
	  $html = "<select name='$nombre'>";
	  foreach ($valores as $valor) {
	  if (is_array($valor)) {
	  $value = $valor[$claveValor];
	  $texto = $valor[$claveVisible];
	  } else {
	  $value = $valor;
	  $texto = $valor;
	  }

	  if ($valorSeleccionado !== FALSE && $value == $valorSeleccionado) {
	  $seleccionado = 'selected="selected"';
	  } else {
	  $seleccionado = '';
	  }

	  $html .= "<option $seleccionado value='$value'>$texto</option>";
	  }
	  $html .= '</select>';

	  $this->formulario .= $html;
	  }
	 */

	private function addCSS($css) {
		$tab = Tools::getValue('tab', 0);
		if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
			if ($this->context->controller instanceof stdClass) {
				$this->context->controller = new AdminModulesController();
			}
			$this->context->controller->addCss($this->_path . 'forms/' . $css, 'all');
		}
		return;
	}

	private function addJS($js) {
		$tab = Tools::getValue('tab', 0);
		if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {

			if ($this->context->controller instanceof stdClass) {
				$this->context->controller = new AdminModulesController();
			}
			$this->context->controller->addJs($this->_path . 'forms/' . $js);
		}
		return;
	}

	public function getLanguages() {
		$languages = Language::getLanguages();
		return $languages;
	}

}
