<?php

if (!defined('_PS_VERSION_'))
	exit;

class fileeditorimax extends Module {

	public function __construct() {
		$this->name = 'fileeditorimax';
		$this->tab = 'administration';
		$this->version = '1.0.0';
		$this->author = 'Informax';
		$this->need_instance = 0;
		$this->bootstrap = true;

		parent::__construct();

		$this->displayName = $this->l('FILE EDITOR');
	}

	public function install() {
		include(dirname(__FILE__) . '/configuration.php');
		foreach ($configuracion AS $indice => $valor) {
			if (!Configuration::updateGlobalValue($indice, $valor)) {
				$this->_errors[] = $this->l('Se ha producido un error al crear la configuracion: ' . $indice . ':' . $valor);
				return false;
			}
		}

		if (!$this->installTab()) {
			$this->_errors[] = $this->l('Error al instalar el tab');
			return false;
		}
		return (parent::install());
	}

	public function uninstall() {
		include(dirname(__FILE__) . '/configuration.php');
		foreach ($configuracion AS $indice => $valor) {
			if (Configuration::getGlobalValue($indice) !== FALSE) {
				if (!Configuration::deleteByName($indice)) {
					return false;
				}
			}
		}
		if (!$this->uninstallTab()) {
			$this->_errors[] = $this->l('Error al eliminar el tab');
			return false;
		}
		return true;
	}

	public function getContent() {
		
		//$this->context->controller->addJqueryUI('ui.dialog');
		//$this->addJS('jquery.ui.js');
		$this->addJqueryUI('ui.dialog');
		$this->addJS('gsFileManager.js');
		$this->addJS('jquery.form.js');
		$this->addJS('jquery.Jcrop.js');
		$this->addJS('ckeditor/ckeditor.js');
		$this->addCSS('gsFileManager.css');
		$this->addCSS('jquery.Jcrop.css');
		$this->addCSS('css.css');
		
		$html = '<h2>'.$this->name.'</h2>';
		//$html .= '<script src="//cdn.ckeditor.com/4.4.7/standard/ckeditor.js" type="text/javascript"></script>';
		/*
		$html .= '
                <script src="' . $this->_path . 'gsFileManager.js" type="text/javascript"></script>
		<script src="' . $this->_path . 'jquery.form.js" type="text/javascript"></script>
		<script src="' . $this->_path . 'jquery.Jcrop.js" type="text/javascript"></script>
		<script src="//cdn.ckeditor.com/4.4.7/standard/ckeditor.js"></script>
	
		<link href="' . $this->_path . 'gsFileManager.css" rel="stylesheet" type="text/css" media="screen" />
		<link href="' . $this->_path . 'jquery.Jcrop.css" rel="stylesheet" type="text/css" media="screen" />';
		*/

		$html .= '<style>
                    
</style>
                    <script type="text/javascript">		
			$(document).ready( function() {				
				jQuery("#fileTreeDemo").gsFileManager({ script: " ' . $this->_path . 'connectors/GsFileManager.php" });				
			});
		</script>';


		$html .= ' <div id="fileTreeDemo" class="demoto" style="height: 400px;"></div>';

		return $html;
	}

	/**
	 * Crea un nuevo tab.
	 * @param string $clase
	 * @param string $nombre
	 * @param string $padre
	 * @return boolean
	 */
	private function crearTab($clase, $nombre, $padre = '') {
		if (!Tab::getIdFromClassName($clase)) {
			$tab = new Tab();
			$tab->active = 1;
			$tab->class_name = $clase;
			$tab->name = array();
			foreach (Language::getLanguages(true) as $lang) {
				$tab->name[$lang['id_lang']] = $nombre;
			}
			if ($padre == '') {
				$posicion = 0;
			} else {
				$posicion = Tab::getIdFromClassName($padre);
			}
			$tab->id_parent = intval($posicion);
			$tab->module = $this->name;
			try {
				if (!$tab->add()) {
					return false;
				}
			} catch (Exception $exc) {
				return false;
			}
		}

		return true;
	}

	/**
	 * Borra un tab.
	 * @param string $clase
	 * @return boolean
	 */
	private function borrarTab($clase) {
		$id_tab = (int) Tab::getIdFromClassName($clase);
		if ($id_tab) {
			$tab = new Tab($id_tab);
			try {
				if (!$tab->delete()) {
					return false;
				}
			} catch (Exception $exc) {
				return false;
			}
		}

		return true;
	}

	/**
	 * Instala los tabs del m�dulo.
	 * @return boolean
	 */
	private function installTab() {
		include(dirname(__FILE__) . '/configuration.php');

		//Instalamos el root
		if (isset($moduleTabRoot) && $moduleTabRoot) {
			$this->crearTab($moduleTabRoot['clase'], $moduleTabRoot['name']);
		}

		//Instalamos el resto de tabs
		if (isset($moduleTabs) && $moduleTabs) {
			foreach ($moduleTabs AS $moduleTab) {
				$this->borrarTab($moduleTab['clase']);
				if (!$this->crearTab($moduleTab['clase'], $moduleTab['name'], $moduleTab['padre'])) {
					return false;
				}
			}
		}

		return true;
	}

	/**
	 * Desinstala los tabs del m�dulo.
	 * @return boolean
	 */
	private function uninstallTab() {
		include(dirname(__FILE__) . '/configuration.php');

		//Desinstalamos las tabs de este m�dulo
		if (isset($moduleTabs) && $moduleTabs) {
			foreach ($moduleTabs AS $moduleTab) {
				if (!$this->borrarTab($moduleTab['clase'])) {
					return false;
				}
			}
		}

		//Desinstalamos el root si est� vac�o
		if (isset($moduleTabRoot) && $moduleTabRoot) {
			$id_tab = (int) Tab::getIdFromClassName($moduleTabRoot['clase']);
			if ($id_tab && Tab::getNbTabs($id_tab) == 0) {
				if (!$this->borrarTab($moduleTabRoot['clase'])) {
					return false;
				}
			}
		}

		return true;
	}

	function addCSS($css) {
		$tab = Tools::getValue('tab', 0);
		if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
			if ($this->context->controller instanceof stdClass) {
				$this->context->controller = new AdminModulesController();
			}
			$this->context->controller->addCss($this->_path . 'css/' . $css, 'all');
		}		
		return;
	}

	function addJS($js) {
		$tab = Tools::getValue('tab', 0);
		if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
			if ($this->context->controller instanceof stdClass) {
				$this->context->controller = new AdminModulesController();
			}
			$this->context->controller->addJs($this->_path . 'js/' . $js);
		}
		return;
	}

	function addJqueryPlugin($plugin) {
		$tab = Tools::getValue('tab', 0);
		if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
			if ($this->context->controller instanceof stdClass) {
				$this->context->controller = new AdminModulesController();
			}
			$this->context->controller->addJqueryPlugin($plugin);
		}
		return;
	}

	function addJqueryUI($plugin) {
		$tab = Tools::getValue('tab', 0);
		if (!$tab || ($tab && $tab != 'AdminSelfUpgrade')) {
			if ($this->context->controller instanceof stdClass) {
				$this->context->controller = new AdminModulesController();
			}
			$this->context->controller->addJqueryUI($plugin);
		}
		return;
	}

}
