<?php
class IndexController extends pm_Controller_Action
{
    public function init()
    {
        parent::init();

        // Init title for all actions
        $this->view->pageTitle = 'Creacion masiva cuentas correo';

		$contexto = new pm_Context();
		$this->idModulo = $contexto->getModuleId();
    }

    public function indexAction()
    {
        // Default action will be formAction
        $this->_forward('form');
    }

    public function formAction()
    {
        // Display simple text in view
		$this->view->texto = 'Seleccione el archivo con las cuentas de correo y el dominio en el que quiere crearlas';	
		$html = '<form enctype="multipart/form-data" method="post" action="">';
		$idDomain = 0;
		if ($this->getRequest()->isPost()) {
			$post = $this->getRequest()->getPost();
			$idDomain = $post['domain'];
		}
		$html .= $this->setDomains($idDomain);
		$html .= $this->setAntivirus();
		$html .='<div class="form-row">';
		$html .= '<div class="field-name">';
		$html .= '<label>Archivo de cuentas de correo:</label>';
		$html .= '</div>';
		$html .= '<div class="field-value">';
		$html .= '<input type="file" name="archivo" >';	
		$html .= '</div>';
		$html .= '</div>';
		$html .= '<div class="btns-box">';
		$html .= '<div class="box-area">';
		$html .= '<div class="form-row">';
		$html .= '<div class="field-name">';
		$html .= '</div>';
		$html .= '<div class="field-value">';
		$html .= '<span id="btn-send" class="btn action"></span>';
		$html .= '<script type="text/javascript">';
		$html .= '			Jsw.onReady(function() {';
		$html .= '		new Jsw.CommandButton({';
		$html .= '		applyTo: "btn-send",';
		$html .= '		title: "ACEPTAR",';
		$html .= '		cls: "btn",';
		$html .= '		name: "send",';
		$html .= '		value: "",';
		$html .= '		description: "",';
		$html .= '		disabled: false,';
		$html .= '		handler: function(event) { Jsw.submit(this); }';
		$html .= '		});';
		$html .= '		});';
		$html .= '		</script>';
		$html .= '</div>';
		$html .= '</div>';
		$html .= '</div>';
		$html .= '</div>';
		$html .= '</form>';
		$this->view->form = $html;	
	
		if ($this->getRequest()->isPost()) {
			$respuesta = $this->createMails($_FILES, $this->getRequest()->getPost());

			$respuestalist = $this->_getDatosRespuesta($respuesta);	
			$this->view->respuestalist = $respuestalist;
		}
			
    }
    public function procesarRespuestaCreateMails($datos)
    {
        $list = $this->_getDatosRespuesta($datos);
        return $list;
    }
	
	private function _getDatosRespuesta($datos)
    {
        $data = array();
        $iconPath = pm_Context::getBaseUrl() . 'images/icon_16.gif';
        foreach($datos AS $dato) {
			if($dato['codError'] == 1) {
				$password = ' --- ';
			}else {
				$password = $dato['password'];
			}			
            $data[] = array(
                'column-1' => $dato['cuenta'],
                'column-2' => $password,
				'column-3' => $dato['msg']
            );
        }
        $list = new pm_View_List_Simple($this->view, $this->_request);
        $list->setData($data);
        $list->setColumns(array(
            'column-1' => array(
                'title' => 'Cuenta',
                'noEscape' => true,
                'searchable' => true,
            ),
            'column-2' => array(
                'title' => 'Contrase&ntilde;a',
                'noEscape' => true,
                'sortable' => false,
            ),
			'column-3' => array(
                'title' => 'Mensaje',
                'noEscape' => true,
                'sortable' => false,
            ),
        ));
        return $list;
    }
	private function setDomains($idDomain) {
		$html = '';
		$html .='<div class="form-row">';
		$html .= '<div class="field-name">';
		$html .= '<label>Dominio:</label>';
		$html .= '</div>';
		$html .= '<div class="field-value">';
		$respuesta = $this->getDomains();
		$html .= '<select name="domain" />';
		foreach($respuesta->webspace->get->result AS $domain) {
			if($idDomain != 0) {
				$selected = '';
				if($idDomain == $domain->id) {
					$selected = ' selected="selected" ';
				}
			}
			$html .= '<option value="'.$domain->id.'" '.$selected.'>'.$domain->data->gen_info->name.'</option>';
		}
		$html .= '</select>';
		$html .= '</div>';
		$html .= '</div>';
		return $html;
		}
	private function setAntivirus() {
		$html = '';
		$html .= '<div class="form-row">';
		$html .= '	<div class="field-name">';
		$html .= '		<label>Antivirus</label>';
		$html .= '	</div>';
		$html .= '	<div class="field-value">';
		$html .= '		<div class="text-value">';
		
		$html .= '<div class="indent-box">';
		$html .= '	<input type="radio" checked="checked" name="antivirus" id="antivirus-off" class="radio" value="off" />';
		$html .= '	<div class="indent-box-content">';
		$html .= '		<label form="antivirus-off">Sin antivirus</label>';
		$html .= '	</div>';
		$html .= '</div>';
		
		$html .= '<div class="indent-box">';
		$html .= '	<input type="radio" checked="checked" name="antivirus" id="antivirus-in" class="radio" value="in" />';
		$html .= '	<div class="indent-box-content">';
		$html .= '		<label form="antivirus-in">Correo entrante</label>';
		$html .= '	</div>';
		$html .= '</div>';
		
		$html .= '<div class="indent-box">';
		$html .= '	<input type="radio" checked="checked" name="antivirus" id="antivirus-out" class="radio" value="out" />';
		$html .= '	<div class="indent-box-content">';
		$html .= '		<label form="antivirus-out">Correo saliente</label>';
		$html .= '	</div>';
		$html .= '</div>';
		
		
		$html .= '<div class="indent-box">';
		$html .= '	<input type="radio" checked="checked" name="antivirus" id="antivirus-inout" class="radio" value="inout" />';
		$html .= '	<div class="indent-box-content">';
		$html .= '		<label form="antivirus-off">Correo entrante y saliente</label>';
		$html .= '	</div>';
		$html .= '</div>';
		
		$html .= '</div>';	//TEXT-VALUE
		$html .= '</div>';	// FIELD-VALUE
		$html .= '</div>';	// FORM-ROW
		return $html;
	}
	
	private function createMails($files, $post) {
		$respuesta = array();
		$this->_separadorCampos = ';';
		$this->_separadorTexto = '~';		
		$idDominio = $post['domain'];
		$antivirus = $post['antivirus'];
		if(trim($antivirus) == '') {
			$antivirus = 'inout';
		}
		
		if($idDominio) {
			$fh = @fopen($files['archivo']['tmp_name'], 'r');
			if($fh) {
				while($datosTemp = fgetcsv($fh, '100000', $this->_separadorCampos, $this->_separadorTexto)) {
				$temp = array();
					if(count($datosTemp) == 2) {
						if(strpos($datosTemp[0],'@') !== false) {
							$cuentaTemp = explode('@',$datosTemp[0]);
							$cuenta = $cuentaTemp[0];					
						}else {
							$cuenta = $datosTemp[0];
						}
						if(trim($datosTemp[1]) != '') {
							$password = trim($datosTemp[1]);
						}else {
							$password = $this->generatePassword(8,3);
						}
					}
					$respuestaTemp = $this->createMailAccount($idDominio, $cuenta, $password, $antivirus);
					$contexto = new pm_Context($this->idModulo);				
					$contexto->init($this->idModulo);		
					$temp['cuenta'] = $cuenta;
					$temp['password'] = $password;
					if(strtolower($respuestaTemp->mail->create->result->status) == 'ok') {
						$temp['codError'] = 0;
						$temp['id'] = (string)$respuestaTemp->mail->create->result->mailname->id;
						$temp['msg'] = (string)$respuestaTemp->mail->create->result->mailname->name;
					}else {
						$temp['codError'] = 1;
						$temp['id'] = (string)$respuestaTemp->mail->create->result->errcode;
						$temp['msg'] = (string)$respuestaTemp->mail->create->result->errtext;
					}
					$respuesta[] = $temp;				
				}		
			 } 		
		 }
		 return $respuesta;
	}
	private function generatePassword($longitud=10, $fortaleza=2) {
        $cad = "";
        switch ($fortaleza) {
            case 1:
                $str = "ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijklmnpqrstuvwxyz1234567890-_?=)(@$%!/*+,;.:"; //CADENA PARA CONTRASEÑAS DE ALTA SEGURIDAD
                break;
            case 2:
                $str = "ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijklmnpqrstuvwxyz123456789"; //CADENA PARA CONTRASEÑAS NORMALES
                break;
            case 3:
                $str = "abcdefghijklmnpqrstuvwxyz1234567890"; //CADENA PARA CONTRASEÑAS DE BAJA SEGURIDAD
                break;
        }
        for ($i = 0; $i < $longitud; $i++) {
            $inicio = rand(0, strlen($str) - 1);
            $cad .= substr($str, $inicio, 1);
        }
        return $cad;
	}
	
	private function getDomains() {
		$request = '<webspace>
						<get>
						   <filter/>
						   <dataset>
								<gen_info/>
						   </dataset>
						</get>
					</webspace>';
						
		$response = pm_ApiRpc::getService()->call($request);
		return $response;
	}
	private function createMailAccount($idDominio, $cuenta, $password, $antivirus) {
		$request = '<mail>
							<create>
								<filter>
									<site-id>' . $idDominio . '</site-id>
									<mailname>
										<name>' . $cuenta . '</name>
										<mailbox>
											<enabled>true</enabled>
										</mailbox>
										<password>
											<value>' . $password . '</value>
											<type>plain</type>
										</password>
										<antivir>'.$antivirus.'</antivir>
									</mailname>
								</filter>
							</create>
						</mail>';
		$response = pm_ApiRpc::getService()->call($request);		
		return $response;			
		
	}
}
