<?php
class imaxPrestaMobile extends Module {   
   
    public function __construct() {
        $this->name = 'imaxPrestaMobile';
        $this->tab = 'administration';
        $this->version = 1.0;
        $this->author = 'Informax';
        $this->need_instance = 0;
        $this->localTab = 1;
        parent::__construct();
        $this->displayName = $this->l('Acceso Remoto via movil solo Android');
        $this->description = $this->l('Permitimos acceso remoto a Prestashop Mobile Assitant');        
    }

    public function install() {
        if (!Configuration::updateValue('IMAX_USER_MOBILE', '1') 
            || !Configuration::updateValue('IMAX_PASS_MOBILE', '1')
            || !parent::install())                             
            return false;         
        return true;        
    }

    public function uninstall() {
        if (!Configuration::deleteByName('IMAX_USER_MOBILE') 
            || !Configuration::deleteByName('IMAX_PASS_MOBILE')
            || !parent::uninstall())  {
            return false;
        }        
        return true;
    }


    private function _postProcess() { 
        $error = 0;
        if ($_POST['action'] == 'configuracion') {                        
            $usuario = $_POST['usuario'];
            $pass = $_POST['pass'];            
            
            if (!Configuration::updateValue('IMAX_USER_MOBILE', $usuario)) {
                $error = 1;
            }
            if (!Configuration::updateValue('IMAX_PASS_MOBILE', $pass)) {
                $error = 1;
            }
           
            if ($error == 0) {
                $this->_html .= $this->displayConfirmation($this->l('Configuracion guardada correctamente'));
            } else {
                $this->_html .= $this->displayError($this->l('Se ha producido un error al guardar la configuracion'));
            }
        }
  
    }

    private function _displayFormExport() {       
        $idTab = (int) Tools::getValue('id_tab');
        if (!isset($idTab) || $idTab == 0) {
            $idTab = 1;
        }
        $this->_html .= '	   
		<ul id="menuTab">
				<li id="menuTab1" class="menuTabButton' . (($idTab == 1) ? " selected" : "") . '">1. ' . $this->l('Configuracion') . '</li>                                
				<li id="menuTab2" class="menuTabButton' . (($idTab == 2) ? " selected" : "" ) . '">2. ' . $this->l('Instalacion') . '</li>
                                <li id="menuTab3" class="menuTabButton' . (($idTab == 3) ? " selected" : "" ) . '">3. ' . $this->l('Que hace la aplicacion') . '</li>
                                <li id="menuTab4" class="menuTabButton' . (($idTab == 4) ? " selected" : "" ) . '">4. ' . $this->l('Informax') . '</li>
                                <li id="menuTab5" class="menuTabButton' . (($idTab == 5) ? " selected" : "" ) . '">5. ' . $this->l('Ultimas Noticias y Modulos') . '</li>
			</ul>
			<div id="tabList">
				<div id="menuTab1Sheet" class="tabItem' . (($idTab == 1) ? " selected" : "" ) . '">' . $this->_configuracion() . '</div>                                
                                <div id="menuTab2Sheet" class="tabItem' . (($idTab == 2) ? " selected" : "" ) . '">' . $this->_mostrarInstalacion() . '</div>				                                				
                                <div id="menuTab3Sheet" class="tabItem' . (($idTab == 3) ? " selected" : "" ) . '">' . $this->_mostrarAyuda() . '</div>				                                				
                                <div id="menuTab4Sheet" class="tabItem' . (($idTab == 4) ? " selected" : "" ) . '">' . $this->_informax() . '</div>				                                				
                               <div id="menuTab5Sheet" class="tabItem' . (($idTab == 5) ? " selected" : "" ) . '">' . $this->_informaxNews() . '</div>				                                				
                        </div>           
			<br clear="left" />
			<br />
			<style>
				#menuTab { float: left; padding: 0; margin: 0; text-align: left; }
				#menuTab li { text-align: left; float: left; display: inline; padding: 5px; padding-right: 10px; background: #EFEFEF; font-weight: bold; cursor: pointer; border-left: 1px solid #EFEFEF; border-right: 1px solid #EFEFEF; border-top: 1px solid #EFEFEF; }
				#menuTab li.menuTabButton.selected { background: #FFF6D3; border-left: 1px solid #CCCCCC; border-right: 1px solid #CCCCCC; border-top: 1px solid #CCCCCC; }
				#tabList { clear: left; }
				.tabItem { display: none; }
				.tabItem.selected { display: block; background: #FFFFF0; border: 1px solid #CCCCCC; padding: 10px; padding-top: 20px; }
			</style>
			<script>
				$(".menuTabButton").click(function () {
				  $(".menuTabButton.selected").removeClass("selected");
				  $(this).addClass("selected");
				  $(".tabItem.selected").removeClass("selected");
				  $("#" + this.id + "Sheet").addClass("selected");                                 
				});
			</script>';
 
    }

    private function _displayForm() {
        $this->_displayFormExport();
    }

    public function getContent() {
        $this->_html .= '<h2>' . $this->displayName . '</h2>';

        if (!empty($_POST))
            $this->_html .= $this->_postProcess();
        $this->_displayForm();

        return $this->_html;
    }

    public function _configuracion() {
        require_once("class/tools.php");                
          // Prestashop urls
         $shopUrl = ToolsImax::is_https()?'https':'http'.'://'.$_SERVER['HTTP_HOST']. __PS_BASE_URI__;
        // the module path & url        
        $moduleUrl = $shopUrl.'modules/'.$this->name.'/imax-mobile.php'; 
        $this->localTab = 1;
        $usuario = Configuration::get('IMAX_USER_MOBILE');
        $password = Configuration::get('IMAX_PASS_MOBILE');
        $html = '<fieldset>';
        $html .= $this->l('Pasos a seguir:');
        $html .= '<p><ol>';
        $html .= '<li>' . $this->l('Crea un usuario para acceder') . '</li>';
        $html .= '<li>' . $this->l('Crea tu contraseña') . '</li>';   
        $html .= '<li>' . $this->l('Url para Acceder ') . $moduleUrl . '</li>';
        $html .= '<li><a href='. $moduleUrl . '?username='. $usuario .'&password='.$password.' target="_blank"> Prueba de Verificacion </a></li>';
        $html .= '</ol></p>';
        $html .= '</fieldset>';
        $html .= '<fieldset>';
        $html .= '<form action="' . Tools::safeOutput($_SERVER['REQUEST_URI']) . '" method="post">';                
        $html .= '<p><label>' . $this->l('Usuario Acceso') . '</label>';
        $html .= '<input type="text" name="usuario" value="' . $usuario . '" /></p>';
        $html .= '<p><label>' . $this->l('Password Acceso') . '</label>';
        $html .= '<input type="text" name="pass" value="' . $password . '" /></p>';
        $html .= '<input type="submit" name="configuracion" value="' . $this->l('Guardar Configuracion') . '" />';
        $html .= '<input type="hidden" name="action" value="configuracion">';
        $html .= '<input type="hidden" name="id_tab" value="' . $this->localTab . '">';
        $html .= '</form></fieldset>';
        $html .= '';

        return $html;
    }
    private function _mostrarInstalacion() {
        $this->localTab = 2;
        return $this->display(__FILE__, 'tpl/instalacion.tpl');
    }
        private function _mostrarAyuda() {
        $this->localTab = 3;  
        return $this->display(__FILE__, 'tpl/ayuda.tpl');
    }
        private function _informax() {
        $this->localTab = 4; 
        return $this->display(__FILE__, 'tpl/informax.tpl');
    }
     private function _informaxNews() {
        $this->localTab = 5; 
        $long_descripcion=100; 
        $num_noticias=10; 
        $n=0; 
        $noticias = simplexml_load_file('http://www.informax.es/category/modulos-prestashop-actualizacion-modificacion-precios-categorias/feed/'); 
        foreach ($noticias as $noticia) {  
                foreach($noticia as $reg){ 
                        if($reg->title!=NULL && $reg->title!='' && $reg->description!=NULL && $reg->description!='' && $n<$num_noticias){ 
                               $html .=   '<div class="noticia">'; 
                                $html .=  '<h4><a href="'.$reg->link.'" target="_blank">'.$reg->title.'</a></h4>'; 
                                if(strlen($reg->description)>$long_descripcion) 
                                        $html .=  '<p>'.substr($reg->description,0,$long_descripcion).'...</a></p>'; 
                                else if ($reg->description==NULL || $reg->description==''){
                                }
                                else 
                                       $html .=  '<p>'.$reg->description.'</p>'; 
                                $n++; 
                                $html .= '</div>';
                        } 
                } 
        }
        return $html;        
    }

}